<?php

Redux::set_section( Minimog_Redux::OPTION_NAME, array(
	'title'  => __( 'Logo', 'minimog' ),
	'id'     => 'panel_logo',
	'icon'   => 'eicon-logo',
	'fields' => array(
		array(
			'id'      => 'logo_dark',
			'type'    => 'media',
			'title'   => __( 'Dark Version', 'minimog' ),
			'default' => Minimog_Redux::get_default_setting( 'logo_dark' ),
		),
		array(
			'id'      => 'logo_light',
			'type'    => 'media',
			'title'   => __( 'Light Version', 'minimog' ),
			'default' => Minimog_Redux::get_default_setting( 'logo_light' ),
		),
		array(
			'id'            => 'logo_width',
			'title'         => __( 'Logo Width', 'minimog' ),
			'type'          => 'slider',
			'default'       => Minimog_Redux::get_default_setting( 'logo_width' ),
			'min'           => 0,
			'max'           => 400,
			'step'          => 1,
			'display_value' => 'text',
		),
		array(
			'id'            => 'tablet_logo_width',
			'title'         => __( 'Tablet Logo Width', 'minimog' ),
			'type'          => 'slider',
			'default'       => Minimog_Redux::get_default_setting( 'tablet_logo_width' ),
			'min'           => 0,
			'max'           => 400,
			'step'          => 1,
			'display_value' => 'text',
		),
		array(
			'id'            => 'mobile_logo_width',
			'title'         => __( 'Mobile Logo Width', 'minimog' ),
			'type'          => 'slider',
			'default'       => Minimog_Redux::get_default_setting( 'mobile_logo_width' ),
			'min'           => 0,
			'max'           => 400,
			'step'          => 1,
			'display_value' => 'text',
		),
		array(
			'id'             => 'logo_padding',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => array( 'em', 'px', '%' ),
			'units_extended' => true,
			'title'          => __( 'Logo Padding', 'minimog' ),
			'default'        => Minimog_Redux::get_default_setting( 'logo_padding' ),
		),
		array(
			'id'            => 'sticky_logo_width',
			'title'         => __( 'Sticky Logo Width', 'minimog' ),
			'type'          => 'slider',
			'default'       => Minimog_Redux::get_default_setting( 'sticky_logo_width' ),
			'min'           => 0,
			'max'           => 400,
			'step'          => 1,
			'display_value' => 'text',
		),
	),
) );
